/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.mixin.farmersdelight;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.simibubi.create.api.boiler.BoilerHeater;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import plus.dragons.createcentralkitchen.access.farmersdelight.SkilletBlockEntityAccess;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

@Mixin(value={SkilletBlockEntity.class})
public abstract class SkilletBlockEntityMixin
extends SyncedBlockEntity
implements HeatableBlockEntity,
SkilletBlockEntityAccess {
    @Shadow
    @Final
    private ItemStackHandler inventory;
    @Shadow
    private int cookingTime;
    @Shadow
    private int cookingTimeTotal;
    @Shadow
    private int fireAspectLevel;

    private SkilletBlockEntityMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Shadow
    protected abstract Optional<RecipeHolder<CampfireCookingRecipe>> getMatchingRecipe(ItemStack var1);

    @Shadow
    public abstract ItemStack getStoredStack();

    @Override
    public ItemStack addItemToCook(ItemStack stack, boolean simulate) {
        Optional<RecipeHolder<CampfireCookingRecipe>> recipe = this.getMatchingRecipe(stack);
        if (recipe.isPresent() && this.getStoredStack().isEmpty()) {
            if (((Boolean)this.getBlockState().getValue((Property)SkilletBlock.WATERLOGGED)).booleanValue()) {
                return stack;
            }
            boolean wasEmpty = this.getStoredStack().isEmpty();
            ItemStack remainder = this.inventory.insertItem(0, stack.copy(), simulate);
            if (!simulate && !ItemStack.matches((ItemStack)remainder, (ItemStack)stack)) {
                this.cookingTimeTotal = SkilletBlock.getSkilletCookingTime((int)((CampfireCookingRecipe)recipe.get().value()).getCookingTime(), (int)this.fireAspectLevel);
                this.cookingTime = 0;
                if (wasEmpty && this.level != null && this.isHeated(this.level, this.worldPosition)) {
                    this.level.playSound(null, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return remainder;
            }
        }
        return stack;
    }

    @ModifyExpressionValue(method={"cookAndOutputItems"}, at={@At(value="FIELD", target="Lvectorwing/farmersdelight/common/block/entity/SkilletBlockEntity;cookingTime:I", ordinal=0)})
    private int speedUpCooking(int cookTime, ItemStack cookingStack, Level level) {
        float heat;
        BlockPos pos = this.getBlockPos();
        BlockPos heaterPos = pos.below();
        BlockState heaterState = level.getBlockState(heaterPos);
        BoilerHeater heater = (BoilerHeater)BoilerHeater.REGISTRY.get((StateHolder)heaterState);
        if (heater == null && !this.requiresDirectHeat() && heaterState.is(ModTags.HEAT_CONDUCTORS)) {
            heaterPos = pos.below(2);
            heaterState = level.getBlockState(pos.below(2));
            heater = (BoilerHeater)BoilerHeater.REGISTRY.get((StateHolder)heaterState);
        }
        if (heater != null && (heat = heater.getHeat(level, heaterPos, heaterState)) > 0.0f) {
            cookTime += (int)heat;
        }
        return cookTime;
    }
}

